; ******************************************************
;      DC mBOT - Log Viewer/Searcher
; ******************************************************
alias DCLogs { dialog $iif(!$dialog(DCLogs),-m,-v) DCLogs DCLogs }

alias Log.Load {
  window -c @Logs
  window -mkzSl15 @Logs -1 -1 700 300 @Logs
  titlebar @Logs Listing Logs...
  var %x = 1,%y = 1
  while ($findfile($logdir,*.log,%x)) { aline -l @Logs $remove($nopath($findfile($logdir,*.log,%x)),.log) | inc %x }
  while (%y <= $findfile($logdir,*.log,0)) { cline -lc1 @Logs %y | inc %y }
  titlebar @Logs Right-Click On Window for more Options.
  echo -l @Logs 2*** 3Double-Click on an Item from the List to Read it.
  echo -l @Logs 2*** 3Right-Click on the Window for more Options.
}

alias Logs.Load {
  if ($1) {
    did -r DCLogs 12
    clear @Logx
    if ($1 == n) { echo @Logx 2*** 1 You have selected no option(s) to view 'em in list. | return }
    else {
      var %x = 1
      while (%x <= $findfile($logdir,*.log,0)) {
        var %file = $remove($nopath($findfile($logdir,*.log,%x)),.log)
        if (c isincs $1 || a isincs $1) && ($left(%file,1) == $chr(35)) { did -a DCLogs 12 %file }
        elseif (w isincs $1 || a isincs $1) && ($left(%file,1) == $chr(64)) { did -a DCLogs 12 %file }
        elseif (q isincs $1 || a isincs $1) && ($left(%file,1) != $chr(35) && $left(%file,1) != $chr(64)) && ($remove(%file,.log) != $null) { did -a DCLogs 12 %file }
        inc %x
      }
    }
  }
}

menu @Logs {
  dclick {
    clear @Logs
    if (!$sline(@Logs,1)) { echo @Logs 2***4 Select A Log File First! | halt }
    .loadbuf -p @Logs $+(",$logdir,$sline(@Logs,1),.log,")
    .titlebar @Logs (Log of $sline(@Logs,1) $+ )
  }
  Return { window -c @Logs | DCLogs }
  -
  View Selected {
    clear @Logs
    if (!$sline(@Logs,1)) { echo @Logs 2***4 Select a log file first! | return }
    .loadbuf -p @Logs $+(",$logdir,$sline(@Logs,1),.log,")
    .titlebar @Logs (Log of $sline(@Logs,1) $+ )
  }
  -
  Delete Selected {
    if ($input(Delete Selected Logs?,qyvg,Confirmation) == $yes) goto Delete
    else { halt }
    :Delete
    if (!$sline(@Logs,1)) halt
    else {
      .remove $+(",$logdir,$sline(@Logs,1),.log,")
      .echo @Logs 1~>4 $+($sline(@Logs,1),.log) Has Been Deleted!
      dline -l @Logs $sline(@Logs,1).ln
      goto Delete
    }
    :error
    if ($error) { echo @Logs ~> 1An unexcepted4 ERROR1 detected! You cannot remove $+(4,,$sline(@Logs,1),.log,,1,!) | reseterror | return }
  }
  Delete All { 
    var %Result = $input(Are you sure? $+ $crlf $+ You want to DELETE ALL the logs?,wyvg,Confirmation)
    if (%Result == $yes) { 
      var %x = $findfile($logdir,*.log,0,.remove $qt($1-))
      clear @Logx
      Log.Load
    }
  }
  -
  Open Logs Dir.:run $logdir
  -
  Close:window -c @Logs
}

dialog DCLogs {
  title "Log Viewer and Searcher"
  size -1 -1 297 231
  option dbu
  icon $DC.Imgs(Log.ico)
  list 1, -6 -1 315 30, size
  list 2, 4 4 25 25, size
  text "Log Viewer and Searcher", 3, 30 3 278 15
  text "View your old log files and/or remove them. There is a good feature to see them with colors.", 4, 30 17 278 10
  text "List From:", 5, 6 35 32 8, right
  check "#&Channels", 6, 41 34 42 10
  check "&Queries", 7, 88 34 42 10
  check "@&Windows", 8, 135 34 42 10
  check "&All", 9, 182 34 30 10
  button "&Refresh List", 10, 221 34 71 10
  text "Log List:", 11, 6 51 32 8, right
  combo 12, 41 50 178 75, sort size drop
  button "&Delete", 13, 221 50 35 10
  button "Delete A&ll", 14, 257 50 35 10
  button "", 15, 4 63 289 155
  button "&View In List/Window", 16, 4 219 70 10
  button "&Search...", 17, 212 219 40 10
  button "&Close", 18, 253 219 40 10, cancel
}

on *:dialog:DCLogs:*:*:{
  if ($devent == close) {
    window -c @Logx
    var %x = $+($iif($did($dname,6).state,c),$iif($did($dname,7).state,q),$iif($did($dname,8).state,w),$iif($did($dname,9).state,a))
    DCW Logs Settings List %x
  }
  if ($devent == init) {
    window -c @Logx
    MDX SetMircVersion $version
    MDX MarkDialog $dname
    MDX SetControlMDX $dname 2 Toolbar Flat NoDivider Wrap List Arrows > $Bars
    MDX SetBorderStyle $dname 1,2 simple
    MDX SetFont $dname 3 +a 20 700 Arial
    MDX SetFont $dname 4 +a 14 700 Arial
    MDX SetColor $dname 1,2,3,4 background $rgb(199,199,199)
    MDX SetColor $dname 1,2,3,4 textbg $rgb(199,199,199)
    MDX SetColor $dname 1,3 text $rgb(65,141,255)
    MDX SetColor $dname 4 text $rgb(0,0,0)
    did -b $dname 1,2
    did -i $dname 2 1 bmpsize 32 32
    did -i $dname 2 1 setimage icon normal $noqt($DC.Imgs(Log.ico))
    did -a $dname 2 +a 1 $chr(9) $+ Logs
    MDX SetBorderStyle 15 staticedge
    MDX DynamicControl create $dname 15 button -1 -1 140 40
    MDX SetControlMDX $dname 15 window > $Dialogs
    window -ah @Logx -1 -1 290 155
    did -a $dname 15 grab $window(@Logx).hwnd @Logx
    if (c isincs $DCR(Logs,Settings,List)) { did -c $dname 6 }
    if (q isincs $DCR(Logs,Settings,List)) { did -c $dname 7 }
    if (w isincs $DCR(Logs,Settings,List)) { did -c $dname 8 }
    if (a isincs $DCR(Logs,Settings,List)) { did -c $dname 9 | did -b $dname 6-8 }
    Logs.Load $iif($DCR(Logs,Settings,List),$ifmatch,n)
  }
  if ($devent == sclick) {
    if ($did == 9) { did $iif($did(9).state,-bc,-e) $dname 6-8 }
    if ($did == 10) {
      var %x = $+($iif($did($dname,6).state,c),$iif($did($dname,7).state,q),$iif($did($dname,8).state,w),$iif($did($dname,9).state,a))
      Logs.Load $iif(%x,%x,n)
    }
    if ($did == 12) { 
      clear @Logx
      if ($lines($logdir $+ $did($dname,$did).seltext $+ .log) > 400) {
        echo @Logx 2*** 1 You Cannot Open This Log File On This Window; Because It Has Many Lines...
        echo @Logx 2*** 1 Please Press "View in List/Window" Button then you may read that log file.
      }
      else { loadbuf -rpi @Logx $+(",$logdir,$did($dname,$did).seltext,.log,") }
    } 
    if ($did == 13) {
      if ($did(12).sel) {
        var %Result = $input(Delete Selected Logs?,qyvg,Confirmation)
        if (%Result == $yes) {
          .remove $+(",$logdir,$did(3).seltext,.log,")
          did -d DCLogs 12 $did(12).sel
          clear @Logx
          did -r $dname 15
        }
        else { halt }
      } 
    }
    if ($did == 14) { 
      var %Result = $input(Are you sure? $+ $crlf $+ You want to DELETE ALL the logs?,wyvg,Confirmation)
      if (%Result == $yes) { clear @Logx | var %d = $findfile($logdir,*.log,0,.remove $qt($1-)) | did -r DCLogs 12,15 }
      :error
      if ($error) { echo -a ~> 1An unexcepted4 ERROR1 detected! You cannot remove a log file! | reseterror | return }
    }
    if ($did == 16) { dialog -c $dname | Log.Load }
    if ($did == 17) { dialog -c $dname | DC.LS }
  }
}



; [Log Searcher]
alias DC.LS { dialog $iif(!$dialog(DC.LS),-m,-v) DC.LS DC.LS }
alias -l DCShow { did -ra DC.LS 12 $1- }
alias Get.Result {
  var %temp = $+(",$scriptdir,Temp.txt,")
  if ($dialog(DC.LS)) && ($isfile(%temp)) {
    clear @DC.Log
    var %x = 1
    if ($1 == m) {
      while (%x <= $lines(%temp)) {
        var %line = $read(%temp,%x)
        if (%line) { Show.Result $replace($gettok(%line,1,32),@,$chr(32)) $gettok(%line,2-,32) }
        inc %x
      }
    }
    elseif ($1 == n) {
      var %c = 0
      while (%x <= $lines(%temp)) {
        if ($read(%temp,%x)) { inc %c | Show.Result %c $read(%temp,%x) }
        inc %x
      }
    }
  }
}

alias -l Show.Result {
  var %m
  if ($3-) {
    aline -p @DC.Log $+(01,$1,$chr(41),02,$chr(32),Filename:03,$chr(32),$3,01,$chr(32),$str(-,3),02,$chr(32),At Line:03,$chr(32),$2,$chr(32),01,$str(-,3),02,$chr(32),Matched Line:01,$chr(32),$4-)
    aline -p @DC.Log $lf
    %m = $3
  }
  else { aline -p @DC.Log $+(01,$1,$chr(41),02,$chr(32),Matched Filename:01,$chr(32),$2) | %m = $2 }
  set %Match.Logs $addtok(%Match.Logs,%m,32)
}

alias -l DC.MakeItEnd {
  if ($dialog(DC.LS)) {
    did -r DC.LS 15
    if ($remove(%Match.Logs,$chr(32)) == $null) { did -b DC.LS 15,16 }
    else { didtok DC.LS 15 32 $strip(%Match.Logs,burc) | did -e DC.LS 15,16 | did -c DC.LS 15 1 }
    unset %Match.Logs
  }
}

alias -l DC.View.Log {
  var %file = $+(",$logdir,$1,")
  if ($isfile(%file)) {
    if ($window(@DC.Log.View)) { window -c @DC.Log.View }
    window -ak0zx @DC.Log.View
    .titlebar @DC.Log.View Log: $1
    .loadbuf -rpi @DC.Log.View %file
  }
}

alias -l FNCheck {
  if ($1) && ($isfile($qt($2-))) {
    %x = $remove($2-,$logdir,.log)
    if (q isin $1) && ($left(%x,1) != $chr(35)) && ($left(%x,1) != $chr(64)) return $true
    elseif (w isin $1) && ($left(%x,1) == $chr(64)) return $true
    elseif (c isin $1) && ($left(%x,1) == $chr(35)) return $true
    return $false
  }
}

alias -l DC.Search {
  if (!$dialog(DC.LS)) || (- !isin $1) || (+ !isin $2) || (!$3-) { DCShow Error! The search arguments are not valid | return }
  var %results = 0,%key = $strip($3-,burcmo),%temp = $+(",$scriptdir,Temp.txt,")
  DCShow It might take a few minutes, Please wait... $+ $chr(9) $+ Results: %results
  .write -c %temp
  var %fcount = $findfile($logdir,*.log,0)
  if ($1 == -n) {
    while (%fcount > 0) {
      var %file = $findfile($logdir,*.log,%fcount)
      if ($FNCheck($2,%file)) {
        if (%key $iif(s isin $2,isincs,isin) $remove($findfile($logdir,*.log,%fcount),$logdir,.log)) {
          inc %results
          .write -i %temp $replace($remove(%file,$logdir,.log),%key,04 $+ %key $+ )
          DCShow It might take a few minutes, Please wait... $+ $chr(9) $+ Results: %results
        }
      }
      dec %fcount
    }
    var %res = n
    goto Results
  }
  elseif ($1 == -m) {
    while (%fcount > 0) {
      if ($fopen(Searcher)) { .fclose Searcher }
      var %file = $findfile($logdir,*.log,%fcount)
      if ($FNCheck($2,%file)) {
        var %l = 0
        .fopen Searcher $qt(%file)
        while ($fopen(Searcher).pos < $file($qt(%file)).size) {
          inc %l
          var %line = $strip($fread(Searcher),burcmo)
          if (%key $iif(s isin $2,isincs,isin) %line) {
            inc %results
            .write -i %temp $+(%results,@,%l,@,$remove($findfile($logdir,*.log,%fcount),$logdir)) $replace(%line,%key,04 $+ %key $+ )
            DCShow It might take a few minutes, Please wait... $+ $chr(9) $+ Results: %results
          }
        }
      }
      dec %fcount
    }
    var %res = m
  }
  :Results
  DCShow Search succeed in $+($calc($calc($ticks - %Search.Duration) / 1000),ms!) $+ $chr(9) $+ $chr(9) $+ Results: %results
  if (%results > 0) { Get.Result %res }
  else { aline -p @DC.Log 2Results:1 No match were found. }
  DC.MakeItEnd
  unset %Search.Duration
}


dialog DC.LS {
  title "Log Searcher"
  size -1 -1 212 183
  option dbu
  icon $DC.Imgs(Search.ico)
  box "Search", 1, 3 31 206 87
  text "&Find What?", 2, 7 42 31 8, right
  edit "", 3, 40 41 115 10, autohs
  text "Method:", 4, 7 58 31 8, right
  radio "File&names", 5, 34 68 45 10, group
  radio "Match &Texts in Contents", 6, 34 79 83 10
  text "Search In:", 7, 140 58 31 8, right
  check "C&hannels", 8, 168 68 38 10
  check "&Queries", 9, 168 79 37 10
  check "&Windows", 10, 168 90 38 10
  text "Stat&us:", 11, 7 103 31 8, right
  edit "", 12, 40 102 165 10, read autohs
  box "Log Viewer", 13, 3 119 206 48
  text "The Combo-box you see here contains the Log files which the Searcher has found atleast one match in it. So to view them, Select one of them from the Combo-box then click on 'View' button and go ahead!", 14, 8 129 196 22
  combo 15, 40 153 122 50, disable drop
  button "View", 16, 165 153 40 10, disable
  button "&Search Now!", 17, 2 170 50 10
  button "&Reset", 18, 127 170 40 10
  button "&Close", 19, 168 170 40 10, cancel
  list 20, -6 -1 227 30, size
  list 21, 4 4 25 25, size
  text "Log Searcher", 22, 30 3 188 15
  text "Find anything in logs which you don't remember where is that!", 23, 30 17 188 10
  check "Case s&ensitive?", 24, 157 41 49 10
}

on *:dialog:DC.LS:*:*:{
  if ($devent == close) {
    DCW Logs Search In $+($iif($did(8).state,c),$iif($did(9).state,q),$iif($did(10).state,w))
    DCW Logs Search CS $did(24).state
    DCW Logs Search Method $iif($did(5).state,n,m)
    var %temp = $+(",$scriptdir,Temp.txt,")
    if ($isfile(%temp)) { .remove $+(",$scriptdir,Temp.txt,") }
    if (!%DCres) { window -c @DC.Log | DCLogs }
  }
  if ($devent == init) { 
    MDX SetMircVersion $version
    MDX MarkDialog $dname
    MDX SetControlMDX $dname 21 Toolbar Flat NoDivider Wrap List Arrows > $Bars
    MDX SetBorderStyle $dname 20,21 simple
    MDX SetFont $dname 22 +a 20 700 Arial
    MDX SetFont $dname 23 +a 14 700 Arial
    MDX SetColor $dname 20,21,22,23 background $rgb(199,199,199)
    MDX SetColor $dname 20,21,22,23 textbg $rgb(199,199,199)
    MDX SetColor $dname 20,22 text $rgb(65,141,255)
    MDX SetColor $dname 23 text $rgb(0,0,0)
    did -b $dname 20,21
    did -i $dname 21 1 bmpsize 32 32
    did -i $dname 21 1 setimage icon normal $noqt($DC.Imgs(Search.ico))
    did -a $dname 21 +a 1 $chr(9) $+ Log Searcher
    if (c isin $DCR(Logs,Search,In)) { did -c $dname 8 }
    if (q isin $DCR(Logs,Search,In)) { did -c $dname 9 }
    if (w isin $DCR(Logs,Search,In)) { did -c $dname 10 }
    if ($DCR(Logs,Search,CS) == 1) { did -c $dname 24 }
    did -c $dname $iif($DCR(Logs,Search,CS) == n,5,6)
    if ($window(@DC.Log)) { window -c @DC.Log }
    window -ak0zx @DC.Log
    aline -p @DC.Log ***2 Note/Hint: The specified search key will be shown in 4RED color.
    aline -p @DC.Log ***4 ATTENTION: It may took a minute or more for searching the entire log files, So don't think your mIRC is halted! Because Nothing is wrong with it, Wait until see the results :)
  }
  if ($devent == sclick) {
    did $iif($did(15).sel,-e,-b) $dname 16
    if ($did == 16) && ($did(15).sel) { DC.View.Log $did(15).seltext }
    if ($did == 17) {
      did -r $dname 12,15
      clear @DC.Log
      if (!$did(3)) { beep 1 | DCShow Error! No search key defined! | did -f $dname 3 | return }
      if (!$did(5).state) && (!$did(6).state) { beep 1 | DCShow Error! You must choose a search Method! | return }
      if (!$did(8).state) && (!$did(9).state) && (!$did(10).state) { beep 1 | DCShow Error! You must select one of 'Search In' options! | return }
      if ($findfile($logdir,*.log,0) == 0) { beep 1 | DCShow Error! No log were found in the log directory! | return }
      var %x = $+(-,$iif($did(5).state,n,m),$chr(32),+,$iif($did(8).state,c),$iif($did(9).state,q),$iif($did(10).state,w),$iif($did(24).state,s))
      set %Search.Duration $ticks
      DC.Search %x $did(3)
    } 
    if ($did == 18) { set -u2 %DCres 1 | dialog -c $dname | .timer.dcxx -m 1 0 /DC.LS }
  }
}

on *:close:@DC.Log:{
  if ($dialog(DC.LS)) { dialog -c DC.LS }
}
